/*
 *  							PS/2 Keyer
 *
 *  Copyright (C) 2009  David Bern, W2LNX     W2LNX@ARRL.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *  USA, or see <http://www.gnu.org/licenses/>.
 */

/* -------------------------------------------------------------------------- */

enum {		/* interrupt events */

	NO_INTERRUPT,
	RB_INTERRUPT,
	TIMER1_INTERRUPT,		/* reserved */
	TIMER3_INTERRUPT,
	EXT_INTERRUPT,
	EXT1_INTERRUPT,			/* reserved */
	EXT2_INTERRUPT
};

enum {		/* application specific interrupts */

	PADDLE_INTERRUPT 		= RB_INTERRUPT,		
	SPACE_INTERRUPT			= TIMER3_INTERRUPT,
	KEYBOARD_HOST_INTERRUPT	= EXT_INTERRUPT,
	MOUSE_HOST_INTERRUPT	= EXT2_INTERRUPT,
};

/* -------------------------------------------------------------------------- */

void intialize_interrupts(void);

unsigned int get_interrupt_event(void);

void clear_interrupt_event(void);

void set_timer_ms(unsigned long time);

unsigned int get_port_B(void);

/* -------------------------------------------------------------------------- */
